RequireScript("ParticleSystem.js");

function WorldmapLocation(x,y,layer,showDistance,image,text,action){
	
	this.x = x;
	this.y = y;
	this.layer = 0;
	this.showDistance = showDistance;
	this.image = image;
	this.action = action;
	this.text = text;
	this.clr = CreateColor(255,255,255,0);
	this.blck = CreateColor(0,0,0,0);
	this.lastrender = 0;
	this.alpha = 0;
	
}

WorldmapLocation.prototype.renderDescription = function(){
	
	
	
	this.blck.alpha = this.alpha/4*3;
	this.clr.alpha = this.alpha;
	Rectangle(MapToScreenX(this.layer,this.x)-210,MapToScreenY(this.layer,this.y)-190,420,170,this.blck);
	
	this.image.blitMask(MapToScreenX(this.layer,this.x)-200,MapToScreenY(this.layer,this.y)-180,this.clr);
	cfontb.setColorMask(this.clr);
	cfontb.drawTextBox(MapToScreenX(this.layer,this.x)-40,MapToScreenY(this.layer,this.y)-180,230,150,0,this.text);
	

}


function Worldmap(){

		this.hide = false;
		this.locations = [];
		this.influenceCircle = new ParticleSystem();
		this.influenceCircle.produceDelay = 30;
		this.influenceCircle.produceDelayVar = 0;
		
		this.influenceCircle.images = [objectsystem.image.get("influenceCircle.png")];
		this.influenceCircle.randomizeImages = false;
		this.influenceCircle.imageIndex = 0;
		
		this.influenceCircle.startPosition = [0,0];
		this.influenceCircle.startSize = [0,0];
		this.influenceCircle.startRotation = 0;
		this.influenceCircle.startColor = [255,255,255,0];
		
		this.influenceCircle.startPositionVar = [0,0];
		this.influenceCircle.startSizeVar = [0,0];
		this.influenceCircle.startRotationVar = 0;
		this.influenceCircle.startColorVar = [0,0,0,0]
		
		this.influenceCircle.flyPosition = [0,0];
		this.influenceCircle.flySize = [1,1];
		this.influenceCircle.flyRotation = 1;
		this.influenceCircle.flyColor = [0,0,0,25];
		
		this.influenceCircle.flyPositionVar = [0,0];
		this.influenceCircle.flySizeVar = [0,0];
		this.influenceCircle.flyRotationVar = 0;
		this.influenceCircle.flyColorVar = [0,0,0,0];
		
		this.influenceCircle.maxParticles = 5;
		this.influenceCircle.randomizeDelay = 0;
		this.influenceCircle.particleLifetime = 100;
		this.influenceCircle.fadeOutAtPercent = 30;
		this.influenceCircle.produceCount = 1;
		
		
}


Worldmap.prototype.render = function(maincharacter){
	var d = 0;
	var l = 0;
	
	
	for(var i=0;i<this.locations.length;i++){
		d=Math.sqrt(Math.pow(this.locations[i].x-GetPersonX(maincharacter),2)+Math.pow(this.locations[i].y-GetPersonY(maincharacter),2));
		
		if(d<this.locations[i].showDistance&&this.hide==false){
			this.influenceCircle.startProduce();
			this.influenceCircle.startPosition = [this.locations[i].x,this.locations[i].y];
			l = this.locations[i].layer;
			
			if(IsKeyPressed(btn_OK)){
				this.hide = true;
				SetDelayScript(0,this.locations[i].action);
				ClearKey();
				}
			
			
			if(this.locations[i].alpha<=250)this.locations[i].alpha+=5;
			}
		else{
			if(this.locations[i].alpha>=5)this.locations[i].alpha-=5;
			}
		
		if(this.locations[i].alpha>0){
			
			this.locations[i].renderDescription();
			
			}
		
		}
	this.influenceCircle.renderWithMapTransformation(l);
	this.influenceCircle.stopProduce();
}


Worldmap.prototype.addLocation = function(location){

	this.locations.push(location);

}

Worldmap.prototype.clear = function(){

	this.locations = [];
	this.hide = false;

}

g_worldmap = new Worldmap();